<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

$opt_name = industo_get_opt_name();
$theme = wp_get_theme();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type'            => class_exists('Case_Theme_Core') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'industo'),
    'page_title'           => esc_html__('Theme Options', 'industo'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => class_exists('Case_Theme_Core') ? $theme->get('TextDomain') : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    'templates_path'       => get_template_directory() . '/inc/templates/redux/'
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'industo'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'industo'),
            'default' => ''
        ),
        array(
            'id'       => 'dev_mode',
            'type'     => 'switch',
            'title'    => esc_html__('Dev Mode (not recommended)', 'industo'),
            'description' => 'Scss generate css',
            'default'  => false
        ),
        array(
            'id'       => 'mouse_move_animation',
            'type'     => 'switch',
            'title'    => esc_html__('Mouse Move Animation', 'industo'),
            'default'  => false
        ),
        array(
            'title' => esc_html__('Page Loading', 'industo'),
            'type'  => 'section',
            'id' => 'page_lading',
            'indent' => true
        ),
        array(
            'id'       => 'show_page_loading',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Page Loading', 'industo'),
            'subtitle' => esc_html__('Enable page loading effect when you load site.', 'industo'),
            'default'  => false
        ),
        array(
            'id'       => 'loading_type',
            'type'     => 'select',
            'title'    => esc_html__('Loading Style', 'industo'),
            'options'  => array(
                'style-image'  => esc_html__('Image', 'industo'),
                'style1'  => esc_html__('Style 1', 'industo'),
                'style2'  => esc_html__('Style 2', 'industo'),
                'style3'  => esc_html__('Style 3', 'industo'),
                'style4'  => esc_html__('Style 4', 'industo'),
                'style5'  => esc_html__('Style 5', 'industo'),
                'style6'  => esc_html__('Style 6', 'industo'),
                'style7'  => esc_html__('Style 7', 'industo'),
                'style8'  => esc_html__('Style 8', 'industo'),
                'style9'  => esc_html__('Style 9', 'industo'),
                'style10'  => esc_html__('Style 10', 'industo'),
                'style11'  => esc_html__('Style 11', 'industo'),
                'style12'  => esc_html__('Style 12', 'industo'),
                'style13'  => esc_html__('Style 13', 'industo'),
                'style14'  => esc_html__('Style 14', 'industo'),
            ),
            'default'  => 'style1',
            'required' => array( 0 => 'show_page_loading', 1 => 'equals', 2 => '1' ),
            'force_output' => true
        ),
        array(
            'id'       => 'logo_loader',
            'type'     => 'media',
            'title'    => esc_html__('Logo Loader', 'industo'),
            'default' => '',
            'required' => array( 0 => 'loading_type', 1 => 'equals', 2 => 'style-image' ),
            'force_output' => true
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'industo'),
    'icon'   => 'el el-indent-left',
    'fields' => array(
        array(
            'id'          => 'header_layout',
            'type'        => 'select',
            'title'       => esc_html__('Main Header Layout', 'industo'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your header layout first.','industo'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=header' ) ) . '">','</a>'),
            'options'     =>industo_list_post('header'),
            'default'     => '',
        ),
        array(
            'id'          => 'header_layout_sticky',
            'type'        => 'select',
            'title'       => esc_html__('Sticky Header Layout', 'industo'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your header layout first.','industo'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=header' ) ) . '">','</a>'),
            'options'     =>industo_list_post('header'),
            'default'     => '',
        ),
        array(
            'id'       => 'logo_maxh',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Default Max Height', 'industo'),
            'subtitle' => esc_html__('Enter number.', 'industo'),
            'desc'     => esc_html__('Just apply for header Defualt, Not apply for Header Builder', 'industo'),
            'width'    => false,
            'unit'     => 'px'
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Mobile', 'industo'),
    'icon'       => 'el el-picture',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'logo_m',
            'type'     => 'media',
            'title'    => esc_html__('Logo Mobile', 'industo'),
            'subtitle' => esc_html__('Screenshot < 1200px', 'industo'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo.png'
            )
        ),
        array(
            'id'       => 'logo_maxh_sm',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max Height', 'industo'),
            'subtitle' => esc_html__('Enter number.', 'industo'),
            'desc'     => esc_html__('Apply for Logo Hidden Mobile', 'industo'),
            'width'    => false,
            'unit'     => 'px'
        ),
        array(
            'id'       => 'header_mobile_sticky',
            'type'     => 'button_set',
            'title'    => esc_html__('Header Mobile Sticky', 'industo'),
            'options'  => array(
                'on_sticky'  => esc_html__('On', 'industo'),
                'off_sticky'  => esc_html__('Off', 'industo'),
            ),
            'default'  => 'off_sticky'
        ),
        array(
            'id'       => 'h_custom_menu_mobile',
            'type'     => 'select',
            'title'    => esc_html__( 'Custom Menu Mobile', 'industo' ),
            'options'  => industo_get_nav_menu(),
            'default' => '',
        ),
    )
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'industo'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array(

        array(
            'id'           => 'pagetitle',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Page Title', 'industo' ),
            'options'      => array(
                'show'  => esc_html__( 'Show', 'industo' ),
                'hide'  => esc_html__( 'Hide', 'industo' ),
            ),
            'default'      => 'show',
        ),

        array(
            'id'          => 'pagetitle_color',
            'type'        => 'color',
            'title'       => esc_html__('Page Title Color', 'industo'),
            'transparent' => false,
            'default'     => '',
            'output'         => array('#ct-pagetitle .page-title'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'page_title_align',
            'type'     => 'button_set',
            'title'    => esc_html__('Content Align', 'industo'),
            'options' => array(
                'left' => 'Left', 
                'center' => 'Center',
                'right' => 'Right',
             ), 
            'default' => 'center',
            'output'   => array('#ct-pagetitle.ct-pagetitle'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_bg',
            'type'     => 'background',
            'title'    => esc_html__('Background', 'industo'),
            'subtitle' => esc_html__('Page title background.', 'industo'),
            'output'   => array('body #ct-pagetitle'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true,
            'background-image' => true,
            'background-color' => false,
            'background-position' => false,
            'background-repeat' => false,
            'background-size' => false,
            'background-attachment' => false,
            'transparent' => false,
        ),
        array(
            'id'       => 'ptitle_bg_overlay',
            'type'     => 'color_rgba',
            'title'    => esc_html__( 'Background Color Overlay', 'industo' ),
            'subtitle' => esc_html__( 'Page title background color overlay.', 'industo' ),
            'output'   => array( 'background-color' => '#ct-pagetitle:before' ),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true,
        ),
        array(
            'id'             => 'page_title_padding',
            'type'           => 'spacing',
            'output'         => array('body #ct-pagetitle'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Page Title Space Top/Bottom', 'industo'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            ),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'ptitle_breadcrumb_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Breadcrumb', 'industo'),
            'options'  => array(
                'show'  => esc_html__('Show', 'industo'),
                'hidden'  => esc_html__('Hidden', 'industo'),
            ),
            'default'  => 'show',
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'          => 'breadcrumb_color',
            'type'        => 'color',
            'title'       => esc_html__('Breadcrumb Color', 'industo'),
            'transparent' => false,
            'default'     => '',
            'output'         => array('.ct-breadcrumb, .ct-breadcrumb li a:after'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
    )
));

/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Content', 'industo'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array(
        array(
            'id'             => 'content_padding',
            'type'           => 'spacing',
            'output'         => array('#content'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Content Padding', 'industo'),
            'desc'           => esc_html__('Default: Top-95px, Bottom-70px', 'industo'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            )
        ),
        array(
            'id'      => 'search_field_placeholder',
            'type'    => 'text',
            'title'   => esc_html__('Search Form - Text Placeholder', 'industo'),
            'default' => '',
            'desc'           => esc_html__('Default: Search', 'industo'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Blog Default', 'industo'),
    'icon'       => 'el-icon-list',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'archive_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'industo'),
            'subtitle' => esc_html__('Select a sidebar position for blog home, archive, search...', 'industo'),
            'options'  => array(
                'left'  => esc_html__('Left', 'industo'),
                'right' => esc_html__('Right', 'industo'),
                'none'  => esc_html__('Disabled', 'industo')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'archive_date_on',
            'title'    => esc_html__('Date', 'industo'),
            'subtitle' => esc_html__('Show date posted on each post.', 'industo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_categories_on',
            'title'    => esc_html__('Categories', 'industo'),
            'subtitle' => esc_html__('Show category names on each post.', 'industo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_author_on',
            'title'    => esc_html__('Author', 'industo'),
            'subtitle' => esc_html__('Show author names on each post.', 'industo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_comments_on',
            'title'    => esc_html__('Comments', 'industo'),
            'subtitle' => esc_html__('Show Comment on each post.', 'industo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'      => 'archive_readmore_text',
            'type'    => 'text',
            'title'   => esc_html__('Read More Text', 'industo'),
            'default' => '',
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'industo'),
    'icon'       => 'el-icon-file-edit',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'post_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'industo'),
            'subtitle' => esc_html__('Select a sidebar position', 'industo'),
            'options'  => array(
                'left'  => esc_html__('Left', 'industo'),
                'right' => esc_html__('Right', 'industo'),
                'none'  => esc_html__('Disabled', 'industo')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'post_title_position',
            'type'     => 'button_set',
            'title'    => esc_html__('Title Position', 'industo'),
            'options'  => array(
                'ptitle'  => esc_html__('Page Title', 'industo'),
                'content'  => esc_html__('Content', 'industo'),
            ),
            'default'  => 'ptitle'
        ),
        array(
            'id'       => 'post_date_on',
            'title'    => esc_html__('Date', 'industo'),
            'subtitle' => esc_html__('Show date on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_author_on',
            'title'    => esc_html__('Author', 'industo'),
            'subtitle' => esc_html__('Show author name on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_categories_on',
            'title'    => esc_html__('Categories', 'industo'),
            'subtitle' => esc_html__('Show category names on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_comments_on',
            'title'    => esc_html__('Comments', 'industo'),
            'subtitle' => esc_html__('Show Comment on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'post_tags_on',
            'title'    => esc_html__('Tags', 'industo'),
            'subtitle' => esc_html__('Show tag names on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_navigation_on',
            'title'    => esc_html__('Navigation', 'industo'),
            'subtitle' => esc_html__('Show navigation on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'post_related_on',
            'title'    => esc_html__('Post Related', 'industo'),
            'subtitle' => esc_html__('Show Post Related on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'post_social_share_on',
            'title'    => esc_html__('Social Share', 'industo'),
            'subtitle' => esc_html__('Show social share on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => false,
        ),
        array(
            'id'       => 'post_author_box_info',
            'title'    => esc_html__('Author Box Info', 'industo'),
            'subtitle' => esc_html__('Show author box info on single post.', 'industo'),
            'type'     => 'switch',
            'default'  => false
        ),
    )
));

/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'industo'),
        'icon'   => 'el el-shopping-cart',
        'fields' => array(
            array(
                'title' => esc_html__('Products', 'industo'),
                'type'  => 'section',
                'id' => 'shop_products',
                'indent' => true,
            ),
            array(
                'id'       => 'shop_layout',
                'type'     => 'button_set',
                'title'    => esc_html__('Layout', 'industo'),
                'options'  => array(
                    'grid'  => esc_html__('Grid', 'industo'),
                    'list'  => esc_html__('List', 'industo'),
                ),
                'default'  => 'grid'
            ),
            array(
                'id'       => 'sidebar_shop',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Position', 'industo'),
                'subtitle' => esc_html__('Select a sidebar position for archive shop.', 'industo'),
                'options'  => array(
                    'left'  => esc_html__('Left', 'industo'),
                    'right' => esc_html__('Right', 'industo'),
                    'none'  => esc_html__('Disabled', 'industo')
                ),
                'default'  => 'right'
            ),
            array(
                'title' => esc_html__('Products displayed per page', 'industo'),
                'id' => 'product_per_page',
                'type' => 'slider',
                'subtitle' => esc_html__('Number product to show', 'industo'),
                'default' => 12,
                'min'  => 4,
                'step' => 1,
                'max' => 50,
                'display_value' => 'text'
            ),
            array(
                'id'       => 'show_hidden_cart_sidebar',
                'type'     => 'button_set',
                'title'    => esc_html__('Show Hidden Cart Sidebar', 'industo'),
                'subtitle' => esc_html__('Display cart sidebar after add to cart success', 'industo'),
                'options'  => array(
                    'on'  => esc_html__('Enable', 'industo'),
                    'off' => esc_html__('Disable', 'industo'),
                ),
                'default'  => 'on'
            ),
            array(
                'title' => esc_html__('Single Product', 'industo'),
                'type'  => 'section',
                'id' => 'shop_single',
                'indent' => true,
            ),
            array(
                'id'       => 'product_social_share',
                'type'     => 'switch',
                'title'    => esc_html__('Social Share', 'industo'),
                'default'  => false
            ),
        )
    ));
}

/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'industo'),
    'icon'   => 'el el-website',
    'fields' => array(
        array(
            'id'          => 'footer_layout_custom',
            'type'        => 'select',
            'title'       => esc_html__('Layout', 'industo'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','industo'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
            'options'     =>industo_list_post('footer'),
            'default'     => '',
        ),
        array(
            'id'       => 'back_totop_on',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Button', 'industo'),
            'subtitle' => esc_html__('Show back to top button when scrolled down.', 'industo'),
            'default'  => false,
        ),
        array(
            'id'       => 'fixed_footer',
            'type'     => 'switch',
            'title'    => esc_html__('Fixed Footer', 'industo'),
            'default'  => false,
        ),
    )
));

/* 404 Page /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('404 Page', 'industo'),
    'icon'   => 'el-cog-alt el',
    'fields' => array(
        array(
            'id'       => 'page_404',
            'type'     => 'button_set',
            'title'    => esc_html__('Select 404 Page', 'industo'),
            'options'  => array(
                'default'  => esc_html__('Default', 'industo'),
                'custom'  => esc_html__('Custom', 'industo'),
            ),
            'default'  => 'default'
        ),
        array(
            'id'          => 'page_custom_404',
            'type'        => 'select',
            'title'       => esc_html__('Page', 'industo'),
            'options'     => industo_list_post('page'),
            'default'     => '',
            'required' => array( 0 => 'page_404', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
    ),
));

/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'industo'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'industo'),
            'transparent' => false,
            'default'     => '#fa4318'
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'industo'),
            'transparent' => false,
            'default'     => '#020033'
        ),
        array(
            'id'          => 'third_color',
            'type'        => 'color',
            'title'       => esc_html__('Third Color', 'industo'),
            'transparent' => false,
            'default'     => '#666666'
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'industo'),
            'default' => array(
                'regular' => '#fa4318',
                'hover'   => '#fa4318',
                'active'  => '#fa4318'
            ),
            'output'  => array('a')
        ),
        array(
            'id'          => 'gradient_color',
            'type'        => 'color_gradient',
            'title'       => esc_html__('Gradient Color', 'industo'),
            'transparent' => false,
            'default'  => array(
                'from' => '#fa4318',
                'to'   => '#1227b8', 
            ),
        ),
        array(
            'id'       => 'body_bg_color',
            'type'     => 'background',
            'title'    => esc_html__('Body Background Color', 'industo'),
            'output'   => array( 'background-color' => 'body' ),
            'force_output' => true,
            'background-image' => false,
            'background-color' => true,
            'background-position' => false,
            'background-repeat' => false,
            'background-size' => false,
            'background-attachment' => false,
            'transparent' => false,
            'default'  => ''
        ),
        array(
            'id'          => 'body_text_color',
            'type'        => 'color',
            'title'       => esc_html__('Body Text Color', 'industo'),
            'transparent' => false,
            'output'      => array('body'),
        ),
        array(
            'id'          => 'heading_color',
            'type'        => 'color',
            'title'       => esc_html__('Heading Color', 'industo'),
            'transparent' => false,
            'output'      => array('h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6'),
        ),
    )
));

/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
$custom_font_selectors_1 = Redux::get_option($opt_name, 'custom_font_selectors_1');
$custom_font_selectors_1 = !empty($custom_font_selectors_1) ? explode(',', $custom_font_selectors_1) : array();
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'industo'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'       => 'body_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Body Default Font', 'industo'),
            'options'  => array(
                'Roboto'  => esc_html__('Default', 'industo'),
                'Google-Font'  => esc_html__('Google Font', 'industo'),
            ),
            'default'  => 'Roboto',
        ),
        array(
            'id'          => 'font_main',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'industo'),
            'subtitle'    => esc_html__('This will be the default font of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'color'  => false,
            'output'      => array('body'),
            'units'       => 'px',
            'required' => array( 0 => 'body_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'       => 'heading_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Heading Default Font', 'industo'),
            'options'  => array(
                'Be-Vietnam-Pro'  => esc_html__('Default', 'industo'),
                'Google-Font'  => esc_html__('Google Font', 'industo'),
            ),
            'default'  => 'Be-Vietnam-Pro',
        ),
        array(
            'id'          => 'font_h1',
            'type'        => 'typography',
            'title'       => esc_html__('H1', 'industo'),
            'subtitle'    => esc_html__('This will be the default font for all H1 tags of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h1', '.h1', '.text-heading'),
            'units'       => 'px',
            'color'  => false,
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h2',
            'type'        => 'typography',
            'title'       => esc_html__('H2', 'industo'),
            'subtitle'    => esc_html__('This will be the default font for all H2 tags of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h2', '.h2'),
            'units'       => 'px',
            'color'  => false,
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h3',
            'type'        => 'typography',
            'title'       => esc_html__('H3', 'industo'),
            'subtitle'    => esc_html__('This will be the default font for all H3 tags of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h3', '.h3'),
            'units'       => 'px',
            'color'  => false,
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h4',
            'type'        => 'typography',
            'title'       => esc_html__('H4', 'industo'),
            'subtitle'    => esc_html__('This will be the default font for all H4 tags of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h4', '.h4'),
            'units'       => 'px',
            'color'  => false,
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h5',
            'type'        => 'typography',
            'title'       => esc_html__('H5', 'industo'),
            'subtitle'    => esc_html__('This will be the default font for all H5 tags of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h5', '.h5'),
            'units'       => 'px',
            'color'  => false,
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h6',
            'type'        => 'typography',
            'title'       => esc_html__('H6', 'industo'),
            'subtitle'    => esc_html__('This will be the default font for all H6 tags of your website.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h6', '.h6'),
            'units'       => 'px',
            'color'  => false,
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Fonts Selectors', 'industo'),
    'icon'       => 'el el-fontsize',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'custom_font_1',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Font', 'industo'),
            'subtitle'    => esc_html__('This will be the font that applies to the class selector.', 'industo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => $custom_font_selectors_1,
            'units'       => 'px',

        ),
        array(
            'id'       => 'custom_font_selectors_1',
            'type'     => 'textarea',
            'title'    => esc_html__('CSS Selectors', 'industo'),
            'subtitle' => esc_html__('Add class selectors to apply above font.', 'industo'),
            'validate' => 'no_html'
        )
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Extra Post Type', 'industo'),
    'icon'       => 'el el-briefcase',
    'fields'     => array(
        array(
            'title' => esc_html__('Portfolio', 'industo'),
            'type'  => 'section',
            'id' => 'post_portfolio',
            'indent' => true,
        ),
        array(
            'id'      => 'portfolio_slug',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Slug', 'industo'),
            'default' => '',
            'desc'     => 'Default: portfolio',
        ),
        array(
            'id'      => 'portfolio_name',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Name', 'industo'),
            'default' => '',
            'desc'     => 'Default: Portfolio',
        ),
        array(
            'id'      => 'portfolio_category_slug',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Category Slug', 'industo'),
            'default' => '',
            'desc'     => 'Default: portfolio-category',
        ),
        array(
            'id'      => 'portfolio_category_name',
            'type'    => 'text',
            'title'   => esc_html__('Portfolio Category Name', 'industo'),
            'default' => '',
            'desc'     => 'Default: Portfolio Categories',
        ),
        array(
            'id'    => 'archive_portfolio_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'industo' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
        ),
        
        array(
            'title' => esc_html__('Service', 'industo'),
            'type'  => 'section',
            'id' => 'post_service',
            'indent' => true,
        ),
        array(
            'id'      => 'service_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Slug', 'industo'),
            'default' => '',
            'desc'     => 'Default: service',
        ),
        array(
            'id'      => 'service_name',
            'type'    => 'text',
            'title'   => esc_html__('Service Name', 'industo'),
            'default' => '',
            'desc'     => 'Default: Service',
        ),
        array(
            'id'      => 'service_category_slug',
            'type'    => 'text',
            'title'   => esc_html__('Service Category Slug', 'industo'),
            'default' => '',
            'desc'     => 'Default: service-category',
        ),
        array(
            'id'      => 'service_category_name',
            'type'    => 'text',
            'title'   => esc_html__('Service Category Name', 'industo'),
            'default' => '',
            'desc'     => 'Default: Service Categories',
        ),
        array(
            'id'    => 'archive_service_link',
            'type'  => 'select',
            'title' => esc_html__( 'Custom Archive Page Link', 'industo' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
        ),
    )
));

/* Custom Code /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom Code', 'industo'),
    'icon'   => 'el-icon-edit',
    'fields' => array(

        array(
            'id'       => 'site_header_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Header Custom Codes', 'industo'),
            'subtitle' => esc_html__('It will insert the code to wp_head hook.', 'industo'),
        ),
        array(
            'id'       => 'site_footer_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Footer Custom Codes', 'industo'),
            'subtitle' => esc_html__('It will insert the code to wp_footer hook.', 'industo'),
        ),

    ),
));

/* Custom CSS /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom CSS', 'industo'),
    'icon'   => 'el-icon-adjust-alt',
    'fields' => array(

        array(
            'id'   => 'customcss',
            'type' => 'info',
            'desc' => esc_html__('Custom CSS', 'industo')
        ),

        array(
            'id'       => 'site_css',
            'type'     => 'ace_editor',
            'title'    => esc_html__('CSS Code', 'industo'),
            'subtitle' => esc_html__('Advanced CSS Options. You can paste your custom CSS Code here.', 'industo'),
            'mode'     => 'css',
            'validate' => 'css',
            'theme'    => 'chrome',
            'default'  => ""
        ),

    ),
));