<?php
// Add custom field to section
if(!function_exists('industo_custom_section_params')){
    add_filter('ct-custom-section/custom-params', 'industo_custom_section_params'); 
    function industo_custom_section_params(){
        return array(
            'sections' => array(
                array(
                    'name'     => 'ct_row_settings',
                    'label'    => esc_html__( 'Case Settings', 'industo' ),
                    'tab'      => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name'    => 'header_fixed_transparent',
                            'label'   => esc_html__( 'Header Fixed Transparent', 'industo' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'industo' ),
                                'transparent'   => esc_html__( 'Yes', 'industo' ),
                            ),
                            'prefix_class' => 'ct-header-fixed-',
                            'default'      => 'none',
                        ),

                        array(
                            'name'    => 'col_order',
                            'label'   => esc_html__( 'Column Order ( Screen < 1024px)', 'industo' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'industo' ),
                                'order'   => esc_html__( 'Yes', 'industo' ),
                            ),
                            'prefix_class' => 'ct-column-',
                            'default'      => 'none',
                        ),

                        array(
                            'name'    => 'row_scroll_fixed',
                            'label'   => esc_html__( 'Row Scroll - Column Fixed', 'industo' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'industo' ),
                                'fixed'   => esc_html__( 'Yes', 'industo' ),
                            ),
                            'prefix_class' => 'ct-row-scroll-',
                            'default'      => 'none',
                        ),

                        array(
                            'name'    => 'gradient_color',
                            'label'   => esc_html__( 'Background Theme Custom', 'industo' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'        => esc_html__( 'No', 'industo' ),
                                'style-1'   => esc_html__( 'Style 1', 'industo' ),
                            ),
                            'prefix_class' => 'ct-row-gradient--',
                            'default'      => 'none',
                        ),
                        array(
                            'name'    => 'container_custom',
                            'label'   => esc_html__( 'Container Custom', 'industo' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'default'        => esc_html__( 'No', 'industo' ),
                                'custom'   => esc_html__( 'Yes', 'industo' ),
                            ),
                            'prefix_class' => 'ct-row-container--',
                            'default'      => 'default',
                        ),
                    ),
                ),
            ),
        );
    }
}