<?php
// Add custom field to column
if(!function_exists('industo_custom_column_params')){
    add_filter('ct-custom-column/custom-params', 'industo_custom_column_params');
    function industo_custom_column_params(){
        return array(
            'sections' => array(
                array(
					'name'     => 'custom_section',
					'label'    => esc_html__( 'Case Settings', 'industo' ),
					'tab'      => \Elementor\Controls_Manager::TAB_LAYOUT,
					'controls' => array(
                        array(
							'name'    => 'col_sticky',
							'label'   => esc_html__( 'Column Sticky', 'industo' ),
							'type'    => \Elementor\Controls_Manager::SELECT,
							'options' => array(
								'none'           => esc_html__( 'No', 'industo' ),
								'sticky' => esc_html__( 'Yes', 'industo' ),
                            ),
                            'default' => 'none',
                            'prefix_class' => 'ct-column-'
                        ),
                        array(
                            'name'    => 'col_offset',
                            'label'   => esc_html__( 'Column Offset', 'industo' ),
                            'type'    => \Elementor\Controls_Manager::SELECT,
                            'options' => array(
                                'none'           => esc_html__( 'No', 'industo' ),
                                'left' => esc_html__( 'Left', 'industo' ),
                                'right' => esc_html__( 'Right', 'industo' ),
                            ),
                            'default' => 'none',
                            'prefix_class' => 'col-offset-'
                        )
                    )
                )
            )
        );
    }
}