<?php
$default_settings = [
    'title_text' => '',
    'sub_title' => '',
    'team_l6' => '',
    'des_el' => '',
    'thumbnail_size' => 'full',
    'thumbnail_custom_dimension' => '',
];

$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = ct_get_element_id($settings);
if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '500x566';
}

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel ct-slick-arrow-middle',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
    'data-appendArrows' => '#append-arrows-' . $html_id,
] );

if ( ! empty( $settings['el_btn_link']['url'] ) ) {
    $widget->add_render_attribute( 'el_btn_text', 'href', $settings['el_btn_link']['url'] );

    if ( $settings['el_btn_link']['is_external'] ) {
        $widget->add_render_attribute( 'el_btn_text', 'target', '_blank' );
    }

    if ( $settings['el_btn_link']['nofollow'] ) {
        $widget->add_render_attribute( 'el_btn_text', 'rel', 'nofollow' );
    }
}

?>
<?php if(isset($team_l6) && !empty($team_l6) && count($team_l6)): ?>
    <div id="<?php echo esc_attr($html_id) ?>" class="ct-team ct-team-carousel6 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div class="container-custom">
                <div class="wp-meta">
                    <div class="wp-titles">
                        <?php if(!empty($sub_title)) : ?>
                            <div class="el--sub-title">
                                <?php echo wp_kses_post($sub_title); ?>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($settings['title_text'])) : ?>
                            <h3 class="el--title">
                                <?php echo ct_print_html($settings['title_text']); ?>
                            </h3>
                        <?php endif; ?>
                    </div>
                    <?php if(!empty($settings['des_el'])) : ?>
                        <div class="el--description">
                            <?php echo ct_print_html($settings['des_el']); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( ! empty( $settings['el_btn_link']['url'] ) ) { ?>
                        <div class="el-btn">
                            <a class="btn-readmore" <?php ct_print_html($widget->get_render_attribute_string( 'el_btn_text' )); ?>>
                                <span><?php echo esc_html($settings['el_btn_text']); ?></span>
                            </a>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ($team_l6 as $key => $value) :
                    $title = isset($value['title']) ? $value['title'] : '';
                    $position = isset($value['position']) ? $value['position'] : '';
                    $description = isset($value['description']) ? $value['description'] : '';
                    $image = isset($value['image']) ? $value['image'] : '';
                    $link = isset($value['link']) ? $value['link'] : '';
                    $img = ct_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $img_size,
                        'class' => 'no-lazyload',
                    ));
                    $thumbnail = $img['thumbnail'];
                    $social = isset($value['social']) ? $value['social'] : '';
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $link['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $link['url'] );

                        if ( $link['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $link['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-duration="1.2s">
                            <?php if(!empty($image)) { ?>
                                <div class="team-avatar">
                                    <?php if ( ! empty( $link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                        <?php echo wp_kses_post($thumbnail); ?>
                                    <?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                                </div>
                            <?php } ?>
                            <div class="item-body">
                                <div class="item--meta">
                                     <h4 class="item--title el-empty">    
                                        <?php if ( ! empty( $link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?><?php echo ct_print_html($title); ?><?php if ( ! empty( $link['url'] ) ) { ?></a><?php } ?>
                                    </h4>
                                    <div class="item--position el-empty"><?php echo ct_print_html($position); ?></div> 
                                </div>
                                <div class="item--holder">
                                    <div class="item--holder-inner">
                                        <?php if(!empty($social)):
                                            $team_social = json_decode($social, true); ?>
                                            <div class="item--social">
                                                <?php foreach ($team_social as $value): ?>
                                                    <a href="<?php echo esc_url($value['url']); ?>"><i class="<?php echo esc_attr($value['icon']); ?>"></i></a>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $description ) ) { ?>
                                            <div class="item--desc el-empty">
                                                <?php echo ct_print_html($description); ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                       </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div id="<?php echo esc_attr('append-arrows-' . $html_id); ?>" class="append-arrows-custom">
            </div>
        </div>
    </div>
<?php endif; ?>
