<?php 
$default_settings = [
    'title' => '',
    'sub_title' => '',
    'coming_soon_text' => '',
    'image' => '',
    'img_size' => '',
    'image_link' => '',
    'notification' => '',
    'notification_label' => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$size = 'full';
if(!empty($img_size)) {
    $size = $img_size;
} else {
    $size = 'full';
}
$img  = ct_get_image_by_size( array(
    'attach_id'  => $image['id'],
    'thumb_size' => $size,
) );
$thumbnail    = $img['thumbnail'];

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );
    $icon_tag = 'a';

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
if ( ! empty( $settings['link2']['url'] ) ) {
    $widget->add_render_attribute( 'link2', 'href', $settings['link2']['url'] );
    $icon_tag = 'a';

    if ( $settings['link2']['is_external'] ) {
        $widget->add_render_attribute( 'link2', 'target', '_blank' );
    }

    if ( $settings['link2']['nofollow'] ) {
        $widget->add_render_attribute( 'link2', 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( 'link' );
$link_attributes2 = $widget->get_render_attribute_string( 'link2' );

?>
<div class="ct-showcase layout2 <?php echo esc_attr($ct_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="inner-box">
        <?php if ( $settings['notification'] == 'true' ) { ?>
            <?php if( ! empty($settings['notification_label']) ) { ?>
                <span class="item-notification"><?php echo ct_print_html($settings['notification_label']); ?></span>
            <?php } ?>
        <?php } ?>
        <div class="list-dotted">
            <i></i>
            <i></i>
            <i></i>
        </div>
        <div class="item-feature">
            <?php if ( ! empty( $image['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
            <div class="ct-item-links">
                <?php if( ! empty($settings['btn_text1']) || ! empty( $settings['link']['url'] ) ) { ?>
                    <a class="link-1 btn-hover" <?php ct_print_html($widget->get_render_attribute_string( 'link' )); ?>>
                        <span><?php echo ct_print_html($settings['btn_text1']); ?></span>
                    </a>
                <?php } ?>
                <?php if( ! empty($settings['btn_text2']) || ! empty( $settings['link2']['url'] ) ) { ?>
                    <a class="link-2 btn-hover active" <?php ct_print_html($widget->get_render_attribute_string( 'link2' )); ?>>
                        <span><?php echo ct_print_html($settings['btn_text2']); ?></span>
                    </a>
                <?php } ?>
            </div>
            <?php if( ! empty( $settings['coming_soon_text'] ) ) { ?>
                <h5 class="item-coming">
                    <span><?php echo ct_print_html($settings['coming_soon_text']); ?></span>
                </h5>
            <?php } ?>
        </div>
        <div class="item-meta">
            <?php if( ! empty( $settings['title'] ) ) { ?>
                <h3 class="item-title">
                    <?php if( ! empty( $settings['link']['url'] ) ) { ?><a <?php ct_print_html($widget->get_render_attribute_string( 'link' )); ?>><?php } ?>
                            <?php echo ct_print_html($title); ?>
                    <?php if( ! empty( $settings['link']['url'] ) ) { ?></a><?php } ?>
                </h3>
            <?php } ?>
            <?php if( ! empty( $settings['sub_title'] ) ) { ?>
                <h5 class="sub-title">
                    <?php echo ct_print_html($settings['sub_title']); ?>
                    <span></span>
                </h5>
            <?php } ?>
        </div>
    </div>
</div>