<?php
    $default_settings = [
        'ct_animate' => '',
        'style_box' => 'box-nomarl',
    ];
    $settings = array_merge($default_settings, $settings);
    extract($settings);

    $widget->add_render_attribute( 'icon', 'class', [ 'elementor-icon', 'elementor-animation'] );
    
    $icon_tag = 'span';
    
    $icon_attributes = $widget->get_render_attribute_string( 'icon' );
    $has_heading = ! empty( $settings['heading_text'] );
    $widget->add_inline_editing_attributes( 'heading_text', 'none' );
    $html_id = ct_get_element_id($settings);
    $tax = array();
    $source = $widget->get_setting('source', '');
    $orderby = $widget->get_setting('orderby', 'date');
    $order = $widget->get_setting('order', 'desc');
    $limit = $widget->get_setting('limit', 3);
    $post_ids = $widget->get_setting('post_ids', '');
    extract(ct_get_posts_of_grid('service', [
        'source' => $source,
        'orderby' => $orderby,
        'order' => $order,
        'limit' => $limit,
        'post_ids' => $post_ids,
    ]));
    
    $title_tag = $widget->get_setting('title_tag', 'h3');
    $pagination_type = $widget->get_setting('pagination_type', 'pagination');

    $load_more = array(
        'posttype' => 'service',
        'startPage' => $paged,
        'maxPages'  => $max,
        'total'     => $total,
        'perpage'   => $limit,
        'source' => $source,
        'order' => $order,
        'limit' => $limit,
        'title_tag' => $title_tag,
        
        'template_type' => 'service_list_layout1',
    );
?>

<div id="<?php echo esc_attr($html_id) ?>" class="ct-service-list <?php echo esc_attr($style_box);?>">
    <?php if ( $has_heading ) : ?>
        <<?php ct_print_html($settings['heading_size']); ?> class="custom-heading">
            <<?php echo implode( ' ', [ $icon_tag ] ); ?>
                <?php ct_print_html($widget->get_render_attribute_string( 'heading_text' )); ?>>
                <?php echo wp_kses_post($settings['heading_text']); ?></<?php ct_print_html($icon_tag); ?>>
        </<?php ct_print_html($settings['heading_size']); ?>>
    <?php endif; ?>
    <div class="list-items">
        <?php
            $load_more['tax'] = $tax;
            industo_get_post_grid($posts, $load_more);
        ?>
    </div>
</div>