<?php
$default_settings = [

];
$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = ct_get_element_id($settings);

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );
$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');

$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => 'false',
    'data-speed' => $speed,
    'data-colxs' => '1',
    'data-colsm' => '1',
    'data-colmd' => '1',
    'data-collg' => '1',
    'data-colxl' => '1',
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => '1',
    'data-fade' => 'true',
    'data-appendArrows' => '#append-arrows-' . $html_id,
    'data-appendDots' => '#append-dots-' . $html_id,
] );
?>
<?php if(isset($settings['portfolio']) && !empty($settings['portfolio']) && count($settings['portfolio'])): ?>
    <div class="ct-portfolio-external1 ct-slick-slider <?php echo esc_attr($settings['ct_animate']); ?>">
        <div class="ct-portfolio-inner">
            <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
                <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                    <?php foreach ($settings['portfolio'] as $key => $value):
                        $category = isset($value['category']) ? $value['category'] : '';
                        $description = isset($value['description']) ? $value['description'] : '';

                        $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
                        if ( ! empty( $value['link']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                            if ( $value['link']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['link']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        $image = isset($value['image']) ? $value['image'] : '';
                        ?>
                            <div class="slick-slide">
                                <div class="item--inner-primary">
                                    <?php if(!empty($image['url'])) { ?>
                                        <div class="item--image bg-image" style="background-image: url(<?php echo esc_url($image['url']); ?>);"></div>
                                    <?php } ?>
                                    <div class="item--holder">
                                        <div class="bg-image-holder" style="background-image: url(<?php echo esc_url($image['url']); ?>);"></div>
                                        <div class="item--description"><?php echo esc_html($description); ?></div>
                                        <div class="item--category"><?php echo esc_attr($category); ?></div>
                                        <a class="item--link" <?php echo implode( ' ', [ $link_attributes ] ); ?>><i class="caseicon-long-arrow-right-three"></i></a>
                                    </div>
                               </div>
                            </div>
                    <?php endforeach; ?>
                </div>
                <div class="container-custom">
                    <div id="<?php echo esc_attr('append-arrows-' . $html_id); ?>" class="append-arrows-custom">
                        <div id="<?php echo esc_attr('append-dots-' . $html_id); ?>" class="append-dots-custom"></div>
                    </div>        
                </div>
            </div>
            <div class="ct-slick-nav-wrap">
                <div class="el-widget el-empty"><?php echo esc_attr($settings['wg_title']); ?></div>
                <div class="ct-slick-nav" data-dir="<?php echo esc_attr($carousel_dir); ?>" data-nav="20" data-infinite="false">
                    <?php foreach ($settings['portfolio'] as $value_nav): 
                        $title = isset($value_nav['title']) ? $value_nav['title'] : '';
                         if(!empty($image['id'])) { ?>
                            <div class="slick-slide">
                                <div class="item--inner-nav">
                                    <div class="item--title">    
                                        <span><?php echo esc_attr($title); ?></span>
                                    </div>
                               </div>
                            </div>
                        <?php } ?>
                    <?php endforeach; ?>
                </div>
                <?php if( ! empty( $image_small['url'] ) ) : 
                    $img_small  = ct_get_image_by_size( array(
                        'attach_id'  => $image_small['id'],
                        'thumb_size' => 'full',
                    ) );
                    $thumbnail_small    = $img_small['thumbnail'];
                    ?>
                    <div class="ct-image-circle">
                        <div class="image-small">
                            <?php echo wp_kses_post($thumbnail_small); ?>        
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
