<?php
$default_settings = [
    'banner_image' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$source = $widget->get_setting('source', '');
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
extract(ct_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$img_size = $widget->get_setting('img_size', '');
$show_title = $widget->get_setting('show_title', '');
$show_excerpt = $widget->get_setting('show_excerpt', '');
$num_words = $widget->get_setting('num_words', '');
$show_button = $widget->get_setting('show_button', '');
$button_text = $widget->get_setting('button_text', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');

if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );
    $icon_tag = 'a';

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( 'link' );
?>
<?php if (is_array($posts)): ?>
    <div class="ct-portfolio-carousel3 ct-slick-slider">
        <?php if(!empty($banner_image['id'])) {
            $img = ct_get_image_by_size( array(
                'attach_id'  => $banner_image['id'],
                'thumb_size' => '770x430',
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="ct-banner-image">
                <?php echo wp_kses_post($thumbnail); ?>
            </div>
        <?php } ?>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
            <?php foreach ($posts as $post): 
                $portfolio_except = get_post_meta($post->ID, 'portfolio_except', true);
                $portfolio_custom_link = get_post_meta($post->ID, 'portfolio_custom_link', true);
                if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): ?>
                    <div class="carousel-item slick-slide">
                        <div class="grid-item-inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <?php if($show_title == 'true'): ?>
                                <h4 class="item--title">
                                    <?php if($show_button == 'true') : ?><a href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>"><?php endif; ?>
                                        <?php echo esc_attr(get_the_title($post->ID)); ?>
                                    <?php if($show_button == 'true') : ?></a><?php endif; ?>
                                </h4>
                            <?php endif; ?>
                            <?php if($show_excerpt == 'true' && !empty($portfolio_except)): ?>
                                <div class="item--content">
                                    <?php echo wp_trim_words( $portfolio_except, $num_words, $more = null ); ?>
                                </div>
                            <?php endif; ?>
                            <?php if($show_button == 'true') : ?>
                                <div class="item--readmore">
                                    <a href="<?php if(!empty($portfolio_custom_link)) { echo esc_url($portfolio_custom_link); } else { echo esc_url(get_permalink( $post->ID )); } ?>">
                                        <span>
                                            <?php if(!empty($button_text)) {
                                                echo esc_attr($button_text);
                                            } else {
                                                echo esc_html__('Explore More', 'industo');
                                            } ?>
                                        </span>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
            </div>
            <div class="wp-btn">
                <img class="bounce-1" src="<?php echo esc_url(get_template_directory_uri().'/template-parts/svgs/Arrow-btn.png'); ?>" alt="<?php echo esc_attr__('Industry', 'industo'); ?>" />
                <?php if( ! empty($settings['btn_text']) || ! empty( $settings['link']['url'] ) ) { ?>
                    <a class="btn-view-all" <?php ct_print_html($widget->get_render_attribute_string( 'link' )); ?>>
                        <i>+</i>
                        <span><?php echo ct_print_html($settings['btn_text']); ?></span>
                    </a>
                <?php } ?>
            </div>
        </div>
    </div>
<?php endif; ?>