<?php
$default_settings = [
    'list' => '',
    'selected_icon' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$has_icon = ! empty( $settings['ct_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['ct_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();

?>
<?php if(isset($list) && !empty($list) && count($list)): ?>
    <ul class="ct-menu-item">
        <?php
        	foreach ($list as $key => $ct_list): 
                $link_key = $widget->get_repeater_setting_key( 'list', 'value', $key );
                if ( ! empty( $ct_list['item_link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $ct_list['item_link']['url'] );

                    if ( $ct_list['item_link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $ct_list['item_link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );
                $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'fancybox', $key );
                $has_icon = ! empty( $ct_list['ct_icon'] );
                $widget->add_render_attribute( $icon_key, [
                    'class' => $ct_list['ct_icon'],
                    'aria-hidden' => 'true',
                ] );
                ?>
            <li>
                <?php if( $link_attributes) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                    <?php if ( $ct_list['icon_type'] == 'icon' && $has_icon ) : ?>
                        <span class="ct-icon icon-font">
                            <?php
                                if($is_new):
                                    \Elementor\Icons_Manager::render_icon( $ct_list['ct_icon'], [ 'aria-hidden' => 'true' ] );
                            ?>
                            <?php else: ?>
                                <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                            <?php endif; ?>
                        </span>
                    <?php endif; ?>
                    <?php if ( $ct_list['icon_type'] == 'image' && !empty($ct_list['icon_image']) ) : 
                        $img_icon  = ct_get_image_by_size( array(
                            'attach_id'  => $ct_list['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                        ?>
                        <span class="ct-icon icon-image">
                            <?php echo ct_print_html($thumbnail_icon); ?>
                        </span>
                    <?php endif; ?>
            	   <span><?php echo ct_print_html($ct_list['content'])?></span>
                <?php if( $link_attributes) { ?></a><?php } ?>
           </li>
        <?php endforeach; ?>
    </ul>
<?php endif; ?>
