<?php
$default_settings = [
    'title' => '',
    'title_tag' => 'h3',
    'style' => 'st-default',
    'sub_title' => '',
    'text_holder' => '',
    'sub_title_style' => '',
    'text_align' => 'left',
    'ct_animate' => '',
    'ct_animate_delay' => '',
    'image' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings); 
$is_new = \Elementor\Icons_Manager::is_migration_allowed();
$html_id = ct_get_element_id($settings);

$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title );
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-heading h-align-<?php echo esc_attr($text_align); ?> item-<?php echo esc_attr($style); ?>">
    <div class="heading-wrapper">
        <div class="inner-heading">
              <?php if(!empty($text_holder)) : ?>
                <h4 class="title-holder">
                  <?php echo wp_kses_post($text_holder); ?>
                </h4>
              <?php endif; ?>
            	<?php if(!empty($sub_title)) : ?>
            		<div class="item--sub-title <?php echo esc_attr($sub_title_style); ?>">
                        <?php if ($sub_title_style == 'image-bg') {
                            $img  = ct_get_image_by_size( array(
                                'attach_id'  => $image['id'],
                                'thumb_size' => 'full',
                            ) );
                            $thumbnail    = $img['thumbnail'];
                         ?>
                          <div class="img-bg">
                            <?php if ( ! empty( $image['url'] ) ) { echo wp_kses_post($thumbnail); } ?>
                          </div>
                        <?php } ?>
                        <span>
                            <?php echo wp_kses_post($sub_title); ?>
                        </span>
                    </div>
            	<?php endif; ?>
                <<?php echo esc_attr($title_tag); ?> class="item--title case-animate-time <?php echo esc_attr($style); ?> <?php if($ct_animate != 'case-fade-in-up') { echo esc_attr($ct_animate); } ?>" data-wow-delay="<?php echo esc_attr($ct_animate_delay); ?>ms">
                    <?php if($ct_animate == 'case-fade-in-up') {
                        $arr_str = explode(' ', $title);
                        foreach ($arr_str as $index => $value) {
                            $arr_str[$index] = '<span class="slide-in-container"><span class="d-inline-block wow '.$ct_animate.'">' . $value . '</span></span>';
                        }
                        $str = implode(' ', $arr_str);
                        echo wp_kses_post($str);
                    } else {
                        echo '<span>';
                        echo wp_kses_post($editor_title);
                        echo '</span>';
                    } ?>
                </<?php echo esc_attr($title_tag); ?>>
        </div>
    </div>
</div>
