<?php
$default_settings = [
    'fancybox_l7' => '',
    'thumbnail_size' => 'full',
    'thumbnail_custom_dimension' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '500x334';
}

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    //'data-centerMode' => 'true',
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );

?>
<?php if(isset( $fancybox_l7 ) && !empty( $fancybox_l7 ) && count( $fancybox_l7 )): ?>
    <div class="ct-fancybox ct-fancybox-carousel7 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ( $fancybox_l7 as $key => $value ) :
                    $label = isset($value['label']) ? $value['label'] : '';
                    $title = isset($value['title']) ? $value['title'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $btn_text = isset($value['btn_text']) ? $value['btn_text'] : '';
                    $item_link = isset($value['item_link']) ? $value['item_link'] : '';
                    
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $item_link['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $item_link['url'] );

                        if ( $item_link['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $item_link['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <div class="item-header">
                                <div class="item--number">
                                    <?php if ( $key <= 9 ) { ?>
                                        <span class="item-number item-number1">0<?php echo esc_attr($key + 1); ?></span>    
                                    <?php } else { ?>
                                        <span class="item-number item-number1"><?php echo esc_attr($key) ; ?></span>    
                                    <?php } ?>
                                </div>
                                <div class="item-meta">
                                    <?php if(!empty($label)) { ?>
                                        <label class="item--label">    
                                            <?php echo ct_print_html($label); ?>
                                        </label>
                                    <?php } ?>
                                    <?php if(!empty($title)) { ?>
                                        <h3 class="item--title">    
                                            <?php if ( ! empty( $item_link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                                <?php echo ct_print_html($title); ?>
                                            <?php if ( ! empty( $item_link['url'] ) ) { ?></a><?php } ?>
                                        </h3>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="item-content">
                                <?php if(!empty($desc)) { ?>
                                    <div class="item--excerpt">
                                        <?php echo ct_print_html($desc); ?>
                                    </div>
                                <?php } ?>
                                <?php if ( !empty( $item_link['url'] ) || !empty($btn_text) ) { ?>
                                    <a class="item-button" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <i class="icon-before flaticon flaticon-right"></i>
                                        <?php echo ct_print_html($btn_text); ?>
                                        <i class="icon-after flaticon flaticon-right"></i>
                                    </a>
                                <?php } ?>
                            </div>
                       </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
