<?php
$default_settings = [
    'fancybox' => '',
    'thumbnail_size' => 'full',
    'thumbnail_custom_dimension' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = '500x334';
}

$widget->add_render_attribute( 'inner', [
    'class' => 'ct-carousel-inner',
] );

$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$slides_to_scroll = $widget->get_setting('slides_to_scroll', '');

$arrows = $widget->get_setting('arrows');
$dots = $widget->get_setting('dots');
$pause_on_hover = $widget->get_setting('pause_on_hover');
$autoplay = $widget->get_setting('autoplay', '');
$autoplay_speed = $widget->get_setting('autoplay_speed', '5000');
$infinite = $widget->get_setting('infinite');
$speed = $widget->get_setting('speed', '500');
if (is_rtl()) {
    $carousel_dir = 'true';
} else {
    $carousel_dir = 'false';
}
$widget->add_render_attribute( 'carousel', [
    'class' => 'ct-slick-carousel',
    'data-arrows' => $arrows,
    'data-dots' => $dots,
    'data-pauseOnHover' => $pause_on_hover,
    'data-autoplay' => $autoplay,
    'data-autoplaySpeed' => $autoplay_speed,
    'data-infinite' => $infinite,
    'data-speed' => $speed,
    'data-colxs' => $col_xs,
    'data-colsm' => $col_sm,
    'data-colmd' => $col_md,
    'data-collg' => $col_lg,
    'data-colxl' => $col_xl,
    'data-dir' => $carousel_dir,
    'data-slidesToScroll' => $slides_to_scroll,
] );

$has_icon = ! empty( $settings['ct_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['ct_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}
$is_new = \Elementor\Icons_Manager::is_migration_allowed();

?>
<?php if(isset( $fancybox ) && !empty( $fancybox ) && count( $fancybox )): ?>
    <div class="ct-fancybox ct-fancybox-carousel6 ct-slick-slider">
        <div <?php ct_print_html($widget->get_render_attribute_string( 'inner' )); ?>>
            <div <?php ct_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <?php foreach ( $fancybox as $key => $value ) :
                    $title = isset($value['title']) ? $value['title'] : '';
                    $desc = isset($value['desc']) ? $value['desc'] : '';
                    $text_button = isset($value['text_button']) ? $value['text_button'] : '';
                    $item_link = isset($value['item_link']) ? $value['item_link'] : '';
                    
                    $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                    if ( ! empty( $item_link['url'] ) ) {
                        $widget->add_render_attribute( $link_key, 'href', $item_link['url'] );

                        if ( $item_link['is_external'] ) {
                            $widget->add_render_attribute( $link_key, 'target', '_blank' );
                        }

                        if ( $item_link['nofollow'] ) {
                            $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                        }
                    }
                    $link_attributes = $widget->get_render_attribute_string( $link_key );
                    
                    $image = isset($value['image']) ? $value['image'] : '';
                    $img = industo_get_image_by_size( array(
                        'attach_id'  => $image['id'],
                        'thumb_size' => $img_size,
                    ));
                    $thumbnail = $img['thumbnail']; 

                    $icon_key = $widget->get_repeater_setting_key( 'ct_icon', 'fancybox', $key );
                    $has_icon = ! empty( $value['ct_icon'] );
                    $widget->add_render_attribute( $icon_key, [
                        'class' => $value['ct_icon'],
                        'aria-hidden' => 'true',
                    ] );

                    ?>
                    <div class="slick-slide">
                        <div class="item--inner <?php echo esc_attr($settings['ct_animate']); ?>">
                            <div class="item-holder holder-main">
                                <?php if( ! empty( $image_holder['url'] ) ) : 
                                    $img_small  = ct_get_image_by_size( array(
                                        'attach_id'  => $image_holder['id'],
                                        'thumb_size' => 'full',
                                    ) );
                                    $thumbnail_small    = $img_small['thumbnail'];
                                    ?>
                                    <div class="ct-image-small">
                                        <div class="inner-image-small">
                                            <?php echo wp_kses_post($thumbnail_small); ?>        
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ( $value['icon_type'] == 'icon' && $has_icon ) : ?>
                                    <span class="ct-icon icon-font">
                                        <?php
                                            if($is_new):
                                                \Elementor\Icons_Manager::render_icon( $value['ct_icon'], [ 'aria-hidden' => 'true' ] );
                                        ?>
                                        <?php else: ?>
                                            <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                                        <?php endif; ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( $value['icon_type'] == 'image' && !empty($value['icon_image']) ) : 
                                    $img_icon  = ct_get_image_by_size( array(
                                        'attach_id'  => $value['icon_image']['id'],
                                        'thumb_size' => 'full',
                                    ) );
                                    $thumbnail_icon    = $img_icon['thumbnail'];
                                    ?>
                                    <span class="ct-icon icon-image">
                                        <?php echo ct_print_html($thumbnail_icon); ?>
                                    </span>
                                <?php endif; ?>
                                    <?php if(!empty($title)) { ?>
                                        <h3 class="item--title">    
                                            <?php echo ct_print_html($title); ?>
                                        </h3>
                                    <?php } ?>
                                <?php if ( ! empty( $item_link['url'] ) ) { ?>
                                    <a class="btn-fcb" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                        <?php if ( !empty( $text_button ) ) {
                                            echo ct_print_html( $text_button );
                                        } else { ?>
                                            <?php echo esc_html__('Read More', 'industo'); ?>
                                        <?php } ?>
                                        <i class="caseicon-long-arrow-right-three"></i>
                                    </a>
                                <?php } ?>
                            </div>      
                            <div class="item-holder holder-hover">
                                <?php if(!empty($image['url'])) { ?>
                                    <div class="item--image" style="background-image: url(<?php echo esc_url($image['url']); ?>);"></div>
                                <?php } ?>
                                <?php if( ! empty( $image_hover['url'] ) ) : 
                                    $img_small2  = ct_get_image_by_size( array(
                                        'attach_id'  => $image_hover['id'],
                                        'thumb_size' => 'full',
                                    ) );
                                    $thumbnail_small2    = $img_small2['thumbnail'];
                                    ?>
                                    <div class="ct-image-small2">
                                        <?php echo wp_kses_post($thumbnail_small2); ?>        
                                    </div>
                                <?php endif; ?>
                                <?php if ( $value['icon_type'] == 'icon' && $has_icon ) : ?>
                                    <span class="ct-icon icon-font">
                                        <?php if ( ! empty( $item_link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                        <?php
                                            if($is_new):
                                                \Elementor\Icons_Manager::render_icon( $value['ct_icon'], [ 'aria-hidden' => 'true' ] );
                                        ?>
                                        <?php else: ?>
                                            <i <?php ct_print_html($widget->get_render_attribute_string( $icon_key )); ?>></i>
                                        <?php endif; ?>
                                        <?php if ( ! empty( $item_link['url'] ) ) { ?></a><?php } ?>
                                    </span>
                                <?php endif; ?>
                                <?php if ( $value['icon_type'] == 'image' && !empty($value['icon_image']) ) : 
                                    $img_icon  = ct_get_image_by_size( array(
                                        'attach_id'  => $value['icon_image']['id'],
                                        'thumb_size' => 'full',
                                    ) );
                                    $thumbnail_icon    = $img_icon['thumbnail'];
                                    ?>
                                    <span class="ct-icon icon-image">
                                        <?php if ( ! empty( $item_link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                            <?php echo ct_print_html($thumbnail_icon); ?>
                                        <?php if ( ! empty( $item_link['url'] ) ) { ?></a><?php } ?>
                                    </span>
                                <?php endif; ?>
                                <div class="entry-content">
                                    <?php if(!empty($title)) { ?>
                                        <h3 class="item--title">    
                                            <?php if ( ! empty( $item_link['url'] ) ) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                                <?php echo ct_print_html($title); ?>
                                            <?php if ( ! empty( $item_link['url'] ) ) { ?></a><?php } ?>
                                        </h3>
                                    <?php } ?>
                                    <?php if(!empty($desc)) { ?>
                                        <div class="item--description">
                                            <?php echo ct_print_html($desc); ?>
                                        </div>
                                    <?php } ?>
                                    <?php if ( ! empty( $item_link['url'] ) ) { ?>
                                        <a class="btn-fcb" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                            <?php if ( !empty( $text_button ) ) {
                                                echo ct_print_html( $text_button );
                                            } else { ?>
                                                <?php echo esc_html__('Read More', 'industo'); ?>
                                            <?php } ?>
                                            <i class="caseicon-long-arrow-right-three"></i>
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                       </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
