<?php
$default_settings = [
    'form_id' => '',
    'title' => '',
    'description' => '',
    'style' => 'style1',
    'image'            => '',
    'ct_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if(class_exists('WPCF7') && !empty($form_id)) : ?>
    <div class="ct-contact-form ct-contact-form-layout1 <?php echo esc_attr($style.' '.$ct_animate); ?>">
        <div class="inner-layout" <?php if($settings['style'] == 'style4') { ?> <?php if( !empty( $settings['image']['url'] ) ) { ?> style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);" <?php } } ?>>
            <?php if(!empty($title) || !empty($description)) : ?>
                <div class="ct-contact-meta">
                    <?php if(!empty($title)) : ?>
                        <h4 class="ct-meta--title"><span><?php echo esc_attr($title); ?></span></h4>
                    <?php endif; ?>
                    <?php if(!empty($description)) : ?>
                        <div class="ct-meta--desc"><?php echo ct_print_html($description); ?></div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="ct-contact-form">
                <?php echo do_shortcode('[contact-form-7 id="'.esc_attr( $form_id ).'"]'); ?>
            </div>
        </div>
    </div>
<?php endif; ?>