<?php
// Register Contact Form 7 Widget
if(class_exists('WPCF7')) {
    $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');

    $contact_forms = array();
    if ($cf7) {
        foreach ($cf7 as $cform) {
            $contact_forms[$cform->ID] = $cform->post_title;
        }
    } else {
        $contact_forms[esc_html__('No contact forms found', 'industo')] = 0;
    }


    ct_add_custom_widget(
        array(
            'name' => 'ct_contact_form',
            'title' => esc_html__('CT Contact Form', 'industo'),
            'icon' => 'eicon-form-horizontal',
            'categories' => array(Case_Theme_Core::CT_CATEGORY_NAME),
            'scripts' => array(
                'jquery-ui-slider',
                'ct-elementor-js',
            ),
            'params' => array(
                'sections' => array(
                    array(
                        'name' => 'source_section',
                        'label' => esc_html__('Source Settings', 'industo'),
                        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                        'controls' => array(
                            array(
                                'name' => 'form_id',
                                'label' => esc_html__('Select Form', 'industo'),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => $contact_forms,
                            ),
                            array(
                                'name' => 'title',
                                'label' => esc_html__('Title', 'industo' ),
                                'type' => \Elementor\Controls_Manager::TEXT,
                                'label_block' => true,
                            ),
                            array(
                                'name' => 'description',
                                'label' => esc_html__('Description', 'industo' ),
                                'type' => \Elementor\Controls_Manager::TEXTAREA,
                                'rows' => 10,
                                'show_label' => false,
                            ),
                            array(
                                'name' => 'style',
                                'label' => esc_html__('Style', 'industo' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'style1' => 'Default',
                                    'style2' => 'Style Border Gray',
                                    'style3' => 'Background Color Dark',
                                    'style4' => 'Background Image',
                                ],
                                'default' => 'style1',
                            ),
                            array(
                                'name' => 'image',
                                'label' => esc_html__('Choose Image', 'industo' ),
                                'type' => \Elementor\Controls_Manager::MEDIA,
                                'condition' => [
                                    'style' => 'style4',
                                ],
                            ),
                            array(
                                'name' => 'thumbnail',
                                'label' => esc_html__('Image Size', 'industo' ),
                                'type' => \Elementor\Group_Control_Image_Size::get_type(),
                                'control_type' => 'group',
                                'default' => 'full',
                                'condition' => [
                                    'style' => 'style4',
                                ],                                
                            ),
                        ),
                    ),
                    array(
                        'name' => 'tab_style_title',
                        'label' => esc_html__('El Title', 'industo'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'title_color',
                                'label' => esc_html__('Title Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .ct-contact-meta .ct-meta--title' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'title_typography',
                                'label' => esc_html__('Title Typography', 'industo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .ct-contact-form .ct-contact-meta .ct-meta--title',
                            ),
                            array(
                                'name' => 'desc_color',
                                'label' => esc_html__('Description Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .ct-contact-meta .ct-meta--desc' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'desc_typography',
                                'label' => esc_html__('Description Typography', 'industo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .ct-contact-form .ct-contact-meta .ct-meta--desc',
                            ),
                            array(
                                'name' => 'ct_animate',
                                'label' => esc_html__('Case Animate', 'industo' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => industo_animate(),
                                'default' => '',
                            ),
                        ),
                    ),      
                    array(
                        'name' => 'tab_style_input',
                        'label' => esc_html__('Input', 'industo'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'input_typography',
                                'label' => esc_html__('Typography', 'industo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select-higthlight',
                            ),
                            array(
                                'name' => 'input_color',
                                'label' => esc_html__('Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select-higthlight' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'input_bg_color',
                                'label' => esc_html__('Background Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select-higthlight' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'input_padding',
                                'label' => esc_html__('Padding Input', 'industo' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit):not(.wpcf7-textarea), {{WRAPPER}} .ct-contact-form .ct-select-higthlight' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'input_border_radius',
                                'label' => esc_html__('Border Radius', 'industo' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select .ct-select-higthlight' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'border_type',
                                'label' => esc_html__( 'Border Type', 'industo' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    '' => esc_html__( 'None', 'industo' ),
                                    'solid' => esc_html__( 'Solid', 'industo' ),
                                    'double' => esc_html__( 'Double', 'industo' ),
                                    'dotted' => esc_html__( 'Dotted', 'industo' ),
                                    'dashed' => esc_html__( 'Dashed', 'industo' ),
                                    'groove' => esc_html__( 'Groove', 'industo' ),
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select .ct-select-higthlight' => 'border-style: {{VALUE}} !important;',
                                ],
                            ),
                            array(
                                'name' => 'border_width',
                                'label' => esc_html__( 'Border Width', 'industo' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select .ct-select-higthlight' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                                ],
                                'condition' => [
                                    'border_type!' => '',
                                ],
                                'responsive' => true,
                            ),
                            array(
                                'name' => 'border_color',
                                'label' => esc_html__( 'Border Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'default' => '',
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit), {{WRAPPER}} .ct-contact-form .ct-select .ct-select-higthlight' => 'border-color: {{VALUE}} !important;',
                                ],
                                'condition' => [
                                    'border_type!' => '',
                                ],
                            ),
                            array(
                                'name' => 'input_height',
                                'label' => esc_html__('Input Height', 'industo' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 300,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control:not(.wpcf7-submit):not(.wpcf7-textarea), {{WRAPPER}} .ct-contact-form .ct-select-higthlight' => 'height: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'textarea_height',
                                'label' => esc_html__('Textarea Height', 'industo' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control.wpcf7-textarea' => 'height: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'input_spacer_bottom',
                                'label' => esc_html__('Spacer Bottom', 'industo' ),
                                'type' => \Elementor\Controls_Manager::SLIDER,
                                'control_type' => 'responsive',
                                'size_units' => [ 'px' ],
                                'range' => [
                                    'px' => [
                                        'min' => 0,
                                        'max' => 3000,
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-form-control-wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                                ],
                            ),
                        ),
                    ),
                    array(
                        'name' => 'tab_style_button',
                        'label' => esc_html__('Button', 'industo'),
                        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                        'controls' => array(
                            array(
                                'name' => 'btn_align',
                                'label' => esc_html__('Button Alignment', 'industo' ),
                                'type' => \Elementor\Controls_Manager::CHOOSE,
                                'control_type' => 'responsive',
                                'options' => [
                                    'left' => [
                                        'title' => esc_html__('Left', 'industo' ),
                                        'icon' => 'fa fa-align-left',
                                    ],
                                    'center' => [
                                        'title' => esc_html__('Center', 'industo' ),
                                        'icon' => 'fa fa-align-center',
                                    ],
                                    'right' => [
                                        'title' => esc_html__('Right', 'industo' ),
                                        'icon' => 'fa fa-align-right',
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .input-filled' => 'text-align: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'button_padding',
                                'label' => esc_html__('Padding', 'industo' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-submit, {{WRAPPER}} .ct-contact-form button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                                'control_type' => 'responsive',
                            ),
                            array(
                                'name' => 'btn_border_radius',
                                'label' => esc_html__('Button Border Radius', 'industo' ),
                                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                                'size_units' => [ 'px' ],
                                'selectors' => [
                                    '{{WRAPPER}} .input-filled .wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                                ],
                            ),
                            array(
                                'name' => 'btn_width',
                                'label' => esc_html__('Button Width', 'industo' ),
                                'type' => \Elementor\Controls_Manager::CHOOSE,
                                'control_type' => 'responsive',
                                'options' => [
                                    '100%' => [
                                        'title' => esc_html__('100%', 'industo' ),
                                        'icon' => 'eicon-text-align-justify',
                                    ],
                                    'auto' => [
                                        'title' => esc_html__('Auto', 'industo' ),
                                        'icon' => 'eicon-h-align-stretch',
                                    ],
                                ],
                                'selectors' => [
                                    '{{WRAPPER}} .input-filled .wpcf7-submit' => 'width: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'btn_typography',
                                'label' => esc_html__('Button Text Typography', 'industo' ),
                                'type' => \Elementor\Group_Control_Typography::get_type(),
                                'control_type' => 'group',
                                'selector' => '{{WRAPPER}} .ct-contact-form-layout1 .wpcf7-submit',
                            ),
                            array(
                                'name' => 'button_color',
                                'label' => esc_html__('Button Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-submit' => 'color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'bg_button_color',
                                'label' => esc_html__('Background Color', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-submit' => 'background-color: {{VALUE}};',
                                ],
                            ),
                            array(
                                'name' => 'bg_button_color_hv',
                                'label' => esc_html__('Background Color Hover', 'industo' ),
                                'type' => \Elementor\Controls_Manager::COLOR,
                                'selectors' => [
                                    '{{WRAPPER}} .ct-contact-form .wpcf7-submit:hover' => 'background-color: {{VALUE}};',
                                ],
                            ),
                        ),
                    ), 
                ),
            ),
        ),
        get_template_directory() . '/elementor/core/widgets/'
    );
}