<?php

$files = scandir(get_template_directory() . '/elementor/core/register');

foreach ($files as $file){
    $pos = strrpos($file, ".php");
    if($pos !== false){
        require_once get_template_directory() . '/elementor/core/register/' . $file;
    }
}

if(!function_exists('industo_register_icons_library')){
    add_filter('elementor/icons_manager/native', 'industo_register_icons_library');
    function industo_register_icons_library($tabs){
        $custom_tabs = [
            'extra_icon_version1' => [
                'name' => 'flaticon',
                'label' => esc_html__( 'Flaticon V1', 'industo' ),
                'url' => get_template_directory_uri() . '/assets/css/flaticon.css',
                'enqueue' => [  ],
                'prefix' => 'flaticon-',
                'displayPrefix' => 'flaticon',
                'labelIcon' => 'flaticon-automation-1',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/elementor-icon/flaticon.js',
                'native' => true,
            ],
            'extra_icon_version2' => [
                'name' => 'flaticon2',
                'label' => esc_html__( 'Flaticon V2', 'industo' ),
                'url' => get_template_directory_uri() . '/assets/css/flaticon2.css',
                'enqueue' => [  ],
                'prefix' => 'flaticon2-',
                'displayPrefix' => 'flaticon2',
                'labelIcon' => 'flaticon-automation-1',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/elementor-icon/flaticon2.js',
                'native' => true,
            ],
        ];

        $tabs = array_merge($custom_tabs, $tabs);

        return $tabs;
    }
}