import { useRef, useState } from "react";
import './AutoGeneratedDefaultInput.scss';
import { __ } from "@wordpress/i18n";

const AutoGeneratedDefaultInput = (props) => {
    const {value, proSetting, onChange, description} = props;
    const [copied, setCopied] = useState(false);

    function generateRandomKey( length = 8 ) {
        const characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        let key = "";
        for (let i = 0; i < length; i++) {
            const randomIndex = Math.floor(Math.random() * characters.length);
            key += characters.charAt(randomIndex);
        }
        return key;
    }

    const generateSSOKey = (e) => {
        e.preventDefault();
        const key = generateRandomKey(8);
        onChange( key );
    }

    const handleCopy = (e) => {
        e.preventDefault();
        navigator.clipboard.writeText(value)
            .then(() => {
                setCopied( true );
            });

            setTimeout(() => {
                setCopied(false);
            }, 10000);
    }

    const handleClear = (e) => {
        e.preventDefault();
        onChange("")
    }

    return (
        <>
            <div className="sso-key-section">
            <div className="input-section">
                <input
                    type="text"
                    value={value}
                    onChange={ (e) => onChange( e.target.value ) }
                />
                { value !== "" &&
                    (
                        <button onClick={ handleClear } className="clear-btn">
                            <i className="adminLib-delete"></i>
                        </button>
                    )
                }
            </div>
            { value !== "" ?
                (
                    <button
                        className="copy-btn"
                        onClick={ handleCopy }
                    >
                        <span className="svgIcon">
                            <i class="adminLib-vendor-form-copy"></i>
                            <span className={!copied ? ( 'tooltip tool-clip' ) : ( 'tooltip'  )}> 
                                {!copied ? ( '') : ( <i className="adminLib-success-notification"></i>  )}
                                {!copied ? ( 'Copy to clipboard' ) : ( 'Copied'  )} 
                            </span>
                        </span>
                    </button>
                )
                :
                (
                    <button
                        className="btn-purple generate-btn"
                        onClick={ generateSSOKey }
                    >
                        <i class="adminLib-star_icon"></i>
                        <span class="text">{__("Generate", "catalogx")}</span>
                    </button>
                )
            }
            {
                proSetting && <span className="admin-pro-tag">pro</span>
            }
        </div>
        <p className="settings-metabox-description" dangerouslySetInnerHTML={{__html: description}}></p>
        </>
    );
}

export default AutoGeneratedDefaultInput;